/**
 * @file xmc1_gpio_map.h
 * @date 2016-08-22
 *
 * @cond
 *********************************************************************************************************************
 * XMClib v2.1.16 - XMC Peripheral Driver Library 
 *
 * Copyright (c) 2015-2017, Infineon Technologies AG
 * All rights reserved.                        
 *                                             
 * Redistribution and use in source and binary forms, with or without modification,are permitted provided that the 
 * following conditions are met:   
 *                                                                              
 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following 
 * disclaimer.                        
 * 
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following 
 * disclaimer in the documentation and/or other materials provided with the distribution.                       
 * 
 * Neither the name of the copyright holders nor the names of its contributors may be used to endorse or promote 
 * products derived from this software without specific prior written permission.                                           
 *                                                                              
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE  
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE  FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR  
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                  
 *                                                                              
 * To improve the quality of the software, users are encouraged to share modifications, enhancements or bug fixes with 
 * Infineon Technologies AG dave@infineon.com).                                                          
 *********************************************************************************************************************
 *
 * Change History
 * --------------
 *
 * 2015-02-20:
 *     - Initial draft
 *      
 * 2015-06-20:
 *     - Updated copyright information
 *
 * 2015-08-25:
 *     - Added XMC1400
 *
 * 2016-03-09:
 *     - Fixed VADC_EMUX signals
 *     - Added P1_6_AF_BCCU0_OUT2 for (UC_DEVICE == XMC1202) && (UC_PACKAGE == VQFN40)
 *     - Added HWCTRL_U1C0_DOUTx for XMC14xx
 *
 * 2016-08-22:
 *     - Added P1_5_AF_U0C0_DOUT0 for XMC14xx
 *     - Add missing P4_5_AF_BCCU0_OUT8 for XMC1402/04 64/48 pins package
 *
 * @endcond
 *
 * @brief XMC pin mapping definitions
 */

#ifndef XMC1_GPIO_MAP_H
#define XMC1_GPIO_MAP_H

#if (UC_DEVICE == XMC1100) && (UC_PACKAGE == VQFN24)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1100) && (UC_PACKAGE == VQFN40)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P1_6	XMC_GPIO_PORT1, 6
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_6_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_6_AF_U0C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_6_AF_U0C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1100) && (UC_PACKAGE == TSSOP16)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#endif


#if (UC_DEVICE == XMC1100) && (UC_PACKAGE == TSSOP38)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1200) && (UC_PACKAGE == TSSOP38)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_LEDTS0_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_LEDTS0_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_LEDTS0_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_LEDTS0_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_4_AF_LEDTS0_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_4_AF_LEDTS0_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_5_AF_LEDTS0_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_5_AF_LEDTS0_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_6_AF_LEDTS0_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_6_AF_LEDTS0_COL1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_7_AF_LEDTS0_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_7_AF_LEDTS0_COL0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_8_AF_LEDTS1_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_8_AF_LEDTS0_COLA 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_9_AF_LEDTS1_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_9_AF_LEDTS0_COL6 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_10_AF_LEDTS1_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_10_AF_LEDTS0_COL5	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_11_AF_LEDTS1_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_11_AF_LEDTS0_COL4	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_12_AF_LEDTS1_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_12_AF_LEDTS0_COL3	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_12_AF_LEDTS1_COL3	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_LEDTS1_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_13_AF_LEDTS0_COL2	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_13_AF_LEDTS1_COL2	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_14_AF_LEDTS1_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_14_AF_LEDTS0_COL1	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_14_AF_LEDTS1_COL1	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_BCCU0_OUT8 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_15_AF_LEDTS1_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_15_AF_LEDTS0_COL0	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_15_AF_LEDTS1_COL0	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_LEDTS0_COL0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_0_AF_LEDTS1_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_LEDTS0_COL1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_1_AF_LEDTS1_COL0 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_LEDTS0_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_2_AF_LEDTS1_COL1 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_LEDTS0_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_3_AF_LEDTS1_COL2 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_LEDTS0_COL4 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_4_AF_LEDTS1_COL3 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_LEDTS0_COLA 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_LEDTS1_COL5 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_LEDTS1_COL6 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_LEDTS1_COL4	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_LEDTS1_COL3	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P0_0_HWCTRL_LEDTS0_TSIN7      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_1_HWCTRL_LEDTS0_TSIN6      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_2_HWCTRL_LEDTS0_TSIN5      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_3_HWCTRL_LEDTS0_TSIN4      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_4_HWCTRL_LEDTS0_TSIN3      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_5_HWCTRL_LEDTS0_TSIN2      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_6_HWCTRL_LEDTS0_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_7_HWCTRL_LEDTS0_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_8_HWCTRL_LEDTS1_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_9_HWCTRL_LEDTS1_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_10_HWCTRL_LEDTS1_TSIN2     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_11_HWCTRL_LEDTS1_TSIN3     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_12_HWCTRL_LEDTS1_TSIN4     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_13_HWCTRL_LEDTS1_TSIN5     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_14_HWCTRL_LEDTS1_TSIN6     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_15_HWCTRL_LEDTS1_TSIN7     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1201) && (UC_PACKAGE == VQFN40)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P1_6	XMC_GPIO_PORT1, 6
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_LEDTS0_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_LEDTS0_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_LEDTS0_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_LEDTS0_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_LEDTS0_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_4_AF_LEDTS0_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_LEDTS0_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_5_AF_LEDTS0_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_LEDTS0_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_6_AF_LEDTS0_COL1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_LEDTS0_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_7_AF_LEDTS0_COL0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_LEDTS1_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_8_AF_LEDTS0_COLA 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_LEDTS1_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_9_AF_LEDTS0_COL6 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_LEDTS1_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_10_AF_LEDTS0_COL5	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_LEDTS1_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_11_AF_LEDTS0_COL4	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_LEDTS1_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_12_AF_LEDTS0_COL3	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_12_AF_LEDTS1_COL3	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_LEDTS1_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_13_AF_LEDTS0_COL2	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_13_AF_LEDTS1_COL2	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_LEDTS1_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_14_AF_LEDTS0_COL1	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_14_AF_LEDTS1_COL1	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_LEDTS1_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_15_AF_LEDTS0_COL0	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_15_AF_LEDTS1_COL0	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_LEDTS0_COL0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_0_AF_LEDTS1_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_LEDTS0_COL1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_1_AF_LEDTS1_COL0 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_LEDTS0_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_2_AF_LEDTS1_COL1 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_LEDTS0_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_3_AF_LEDTS1_COL2 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_LEDTS0_COL4 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_4_AF_LEDTS1_COL3 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_LEDTS0_COLA 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_6_AF_VADC_EMUX12 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_6_AF_LEDTS0_COL5 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_6_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_6_AF_U0C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_6_AF_U0C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_LEDTS1_COL5 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_LEDTS1_COL6 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_LEDTS1_COL4	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_LEDTS1_COL3	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P0_0_HWCTRL_LEDTS0_TSIN7      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_1_HWCTRL_LEDTS0_TSIN6      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_2_HWCTRL_LEDTS0_TSIN5      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_3_HWCTRL_LEDTS0_TSIN4      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_4_HWCTRL_LEDTS0_TSIN3      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_5_HWCTRL_LEDTS0_TSIN2      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_6_HWCTRL_LEDTS0_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_7_HWCTRL_LEDTS0_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_8_HWCTRL_LEDTS1_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_9_HWCTRL_LEDTS1_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_10_HWCTRL_LEDTS1_TSIN2     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_11_HWCTRL_LEDTS1_TSIN3     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_12_HWCTRL_LEDTS1_TSIN4     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_13_HWCTRL_LEDTS1_TSIN5     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_14_HWCTRL_LEDTS1_TSIN6     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_15_HWCTRL_LEDTS1_TSIN7     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1201) && (UC_PACKAGE == TSSOP28)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_LEDTS0_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_LEDTS0_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_4_AF_LEDTS0_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_LEDTS0_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_5_AF_LEDTS0_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_LEDTS0_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_6_AF_LEDTS0_COL1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_LEDTS0_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_7_AF_LEDTS0_COL0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_LEDTS1_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_8_AF_LEDTS0_COLA 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_LEDTS1_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_9_AF_LEDTS0_COL6 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_LEDTS1_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_10_AF_LEDTS0_COL5	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_LEDTS1_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_12_AF_LEDTS0_COL3	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_12_AF_LEDTS1_COL3	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_LEDTS1_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_13_AF_LEDTS0_COL2	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_13_AF_LEDTS1_COL2	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_LEDTS1_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_14_AF_LEDTS0_COL1	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_14_AF_LEDTS1_COL1	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_LEDTS1_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_15_AF_LEDTS0_COL0	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_15_AF_LEDTS1_COL0	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_LEDTS0_COL0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_0_AF_LEDTS1_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_LEDTS0_COL1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_1_AF_LEDTS1_COL0 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_LEDTS0_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_2_AF_LEDTS1_COL1 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_LEDTS0_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_3_AF_LEDTS1_COL2 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_LEDTS1_COL5 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_LEDTS1_COL6 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_LEDTS1_COL4	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_LEDTS1_COL3	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P0_0_HWCTRL_LEDTS0_TSIN7      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_4_HWCTRL_LEDTS0_TSIN3      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_5_HWCTRL_LEDTS0_TSIN2      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_6_HWCTRL_LEDTS0_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_7_HWCTRL_LEDTS0_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_8_HWCTRL_LEDTS1_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_9_HWCTRL_LEDTS1_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_10_HWCTRL_LEDTS1_TSIN2     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_12_HWCTRL_LEDTS1_TSIN4     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_13_HWCTRL_LEDTS1_TSIN5     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_14_HWCTRL_LEDTS1_TSIN6     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_15_HWCTRL_LEDTS1_TSIN7     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1201) && (UC_PACKAGE == TSSOP38)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_LEDTS0_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_LEDTS0_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_LEDTS0_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_LEDTS0_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_LEDTS0_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_4_AF_LEDTS0_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_LEDTS0_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_5_AF_LEDTS0_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_LEDTS0_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_6_AF_LEDTS0_COL1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_LEDTS0_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_7_AF_LEDTS0_COL0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_LEDTS1_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_8_AF_LEDTS0_COLA 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_LEDTS1_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_9_AF_LEDTS0_COL6 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_LEDTS1_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_10_AF_LEDTS0_COL5	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_LEDTS1_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_11_AF_LEDTS0_COL4	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_LEDTS1_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_12_AF_LEDTS0_COL3	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_12_AF_LEDTS1_COL3	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_LEDTS1_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_13_AF_LEDTS0_COL2	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_13_AF_LEDTS1_COL2	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_LEDTS1_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_14_AF_LEDTS0_COL1	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_14_AF_LEDTS1_COL1	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_LEDTS1_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_15_AF_LEDTS0_COL0	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_15_AF_LEDTS1_COL0	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_LEDTS0_COL0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_0_AF_LEDTS1_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_LEDTS0_COL1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_1_AF_LEDTS1_COL0 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_LEDTS0_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_2_AF_LEDTS1_COL1 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_LEDTS0_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_3_AF_LEDTS1_COL2 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_LEDTS0_COL4 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_4_AF_LEDTS1_COL3 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_LEDTS0_COLA 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_LEDTS1_COL5 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_LEDTS1_COL6 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_LEDTS1_COL4	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_LEDTS1_COL3	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P0_0_HWCTRL_LEDTS0_TSIN7      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_1_HWCTRL_LEDTS0_TSIN6      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_2_HWCTRL_LEDTS0_TSIN5      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_3_HWCTRL_LEDTS0_TSIN4      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_4_HWCTRL_LEDTS0_TSIN3      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_5_HWCTRL_LEDTS0_TSIN2      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_6_HWCTRL_LEDTS0_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_7_HWCTRL_LEDTS0_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_8_HWCTRL_LEDTS1_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_9_HWCTRL_LEDTS1_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_10_HWCTRL_LEDTS1_TSIN2     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_11_HWCTRL_LEDTS1_TSIN3     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_12_HWCTRL_LEDTS1_TSIN4     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_13_HWCTRL_LEDTS1_TSIN5     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_14_HWCTRL_LEDTS1_TSIN6     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_15_HWCTRL_LEDTS1_TSIN7     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1202) && (UC_PACKAGE == VQFN24)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_BCCU0_OUT8 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1202) && (UC_PACKAGE == VQFN40)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P1_6	XMC_GPIO_PORT1, 6
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_BCCU0_OUT8 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_6_AF_VADC_EMUX12 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_6_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_6_AF_U0C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_6_AF_U0C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1202) && (UC_PACKAGE == TSSOP16)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_BCCU0_OUT8 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#endif


#if (UC_DEVICE == XMC1202) && (UC_PACKAGE == TSSOP28)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_BCCU0_OUT8 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1301) && (UC_PACKAGE == VQFN24)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_CCU80_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_CCU80_OUT33	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_12_AF_CCU80_OUT20	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_CCU80_OUT32	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_CCU80_OUT21	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1301) && (UC_PACKAGE == VQFN40)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P1_6	XMC_GPIO_PORT1, 6
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_CCU80_OUT02 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_CCU80_OUT03 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_CCU80_OUT13 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_CCU80_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_10_AF_CCU80_OUT22	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_CCU80_OUT23	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_CCU80_OUT33	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_12_AF_CCU80_OUT20	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_CCU80_OUT32	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_CCU80_OUT21	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_6_AF_VADC_EMUX12 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_6_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_6_AF_U0C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_6_AF_U0C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1301) && (UC_PACKAGE == TSSOP16)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_CCU80_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#endif


#if (UC_DEVICE == XMC1301) && (UC_PACKAGE == TSSOP38)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_CCU80_OUT02 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_CCU80_OUT03 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_CCU80_OUT13 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_CCU80_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_10_AF_CCU80_OUT22	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_CCU80_OUT23	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_CCU80_OUT33	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_12_AF_CCU80_OUT20	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_CCU80_OUT32	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_CCU80_OUT21	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == VQFN24)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_CCU80_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_12_AF_CCU80_OUT33	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_12_AF_CCU80_OUT20	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_CCU80_OUT32	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_CCU80_OUT21	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_14_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_BCCU0_OUT8 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_15_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == VQFN40)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P1_6	XMC_GPIO_PORT1, 6
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_1_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_CCU80_OUT02 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_CCU80_OUT03 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_CCU80_OUT13 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_CCU80_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_10_AF_CCU80_OUT22	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_CCU80_OUT23	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_12_AF_CCU80_OUT33	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_12_AF_CCU80_OUT20	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_CCU80_OUT32	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_CCU80_OUT21	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_14_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_BCCU0_OUT8 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_15_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_5_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_6_AF_VADC_EMUX12 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_6_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_6_AF_U0C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_6_AF_U0C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == TSSOP16)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_CCU80_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_14_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_BCCU0_OUT8 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_15_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == TSSOP28)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_CCU80_OUT13 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_CCU80_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_10_AF_CCU80_OUT22	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_12_AF_CCU80_OUT33	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_12_AF_CCU80_OUT20	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_CCU80_OUT32	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_CCU80_OUT21	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_14_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_BCCU0_OUT8 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_15_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == TSSOP38)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_1_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_CCU80_OUT02 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_CCU80_OUT03 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_CCU80_OUT13 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_CCU80_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_10_AF_CCU80_OUT22	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_CCU80_OUT23	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_12_AF_CCU80_OUT33	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_12_AF_CCU80_OUT20	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_CCU80_OUT32	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_CCU80_OUT21	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_14_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_BCCU0_OUT8 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_15_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_5_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1401) && (UC_PACKAGE == LQFP64)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P1_6	XMC_GPIO_PORT1, 6
#define P1_7	XMC_GPIO_PORT1, 7
#define P1_8	XMC_GPIO_PORT1, 8
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11
#define P2_12	XMC_GPIO_PORT2, 12
#define P2_13	XMC_GPIO_PORT2, 13
#define P3_0	XMC_GPIO_PORT3, 0
#define P3_1	XMC_GPIO_PORT3, 1
#define P3_2	XMC_GPIO_PORT3, 2
#define P3_3	XMC_GPIO_PORT3, 3
#define P3_4	XMC_GPIO_PORT3, 4
#define P4_0	XMC_GPIO_PORT4, 0
#define P4_1	XMC_GPIO_PORT4, 1
#define P4_2	XMC_GPIO_PORT4, 2
#define P4_3	XMC_GPIO_PORT4, 3
#define P4_4	XMC_GPIO_PORT4, 4
#define P4_5	XMC_GPIO_PORT4, 5
#define P4_6	XMC_GPIO_PORT4, 6
#define P4_7	XMC_GPIO_PORT4, 7
#define P4_8	XMC_GPIO_PORT4, 8
#define P4_9	XMC_GPIO_PORT4, 9
#define P4_10	XMC_GPIO_PORT4, 10
#define P4_11	XMC_GPIO_PORT4, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_LEDTS0_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_LEDTS0_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_LEDTS0_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_2_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_LEDTS0_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_4_AF_LEDTS0_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_4_AF_LEDTS0_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_5_AF_LEDTS0_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_5_AF_LEDTS0_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_LEDTS0_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_6_AF_LEDTS0_COL1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_7_AF_LEDTS0_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_7_AF_LEDTS0_COL0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_VADC_EMUX12 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_7_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_8_AF_LEDTS1_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_8_AF_LEDTS0_COLA 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_9_AF_LEDTS1_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_9_AF_LEDTS0_COL6 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_10_AF_LEDTS1_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_10_AF_LEDTS0_COL5	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_LEDTS1_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_11_AF_LEDTS0_COL4	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_LEDTS1_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_12_AF_LEDTS0_COL3	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_12_AF_LEDTS1_COL3	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_LEDTS1_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_13_AF_LEDTS0_COL2	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_13_AF_LEDTS1_COL2	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_LEDTS1_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_14_AF_LEDTS0_COL1	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_14_AF_LEDTS1_COL1	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_LEDTS1_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_15_AF_LEDTS0_COL0	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_15_AF_LEDTS1_COL0	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_LEDTS0_COL0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_0_AF_LEDTS1_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_LEDTS0_COL1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_1_AF_LEDTS1_COL0 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_LEDTS0_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_2_AF_LEDTS1_COL1 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_LEDTS0_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_3_AF_LEDTS1_COL2 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_LEDTS0_COL4 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_4_AF_LEDTS1_COL3 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_5_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_LEDTS0_COLA 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_6_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_6_AF_LEDTS0_COL5 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_6_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_6_AF_U0C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_6_AF_U0C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_7_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_7_AF_LEDTS0_COL6 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_7_AF_LEDTS1_COL4 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_7_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_7_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_8_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_8_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_8_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_8_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_LEDTS1_COL5 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_LEDTS1_COL6 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_LEDTS1_COL4	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_LEDTS1_COL3	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_12_AF_VADC_EMUX00	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_12_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_12_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_12_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_12_AF_LEDTS2_COL6	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_13_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_13_AF_U1C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_13_AF_VADC_EMUX01	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_13_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_13_AF_CCU41_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_0_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P3_0_AF_LEDTS2_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P3_0_AF_U1C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_0_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_1_AF_LEDTS2_COL0 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P3_1_AF_U1C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_1_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_2_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_2_AF_LEDTS2_COL1 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P3_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_2_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_3_AF_LEDTS2_COL2 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P3_3_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_3_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_4_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_4_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P3_4_AF_LEDTS2_COL3 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P3_4_AF_U1C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_4_AF_U1C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_0_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_0_AF_LEDTS2_COL5 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_0_AF_ERU1_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_0_AF_U1C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_0_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_1_AF_LEDTS2_COL4 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_1_AF_ERU1_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_1_AF_U1C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_1_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_2_AF_ERU1_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_2_AF_U1C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_2_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_3_AF_ERU1_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_3_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_3_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_4_AF_LEDTS2_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_4_AF_LEDTS1_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_4_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_5_AF_LEDTS2_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_5_AF_LEDTS1_COL6 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_5_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_5_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_6_AF_LEDTS2_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_6_AF_LEDTS1_COL5 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_6_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_7_AF_LEDTS2_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_7_AF_LEDTS1_COL4 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_7_AF_U1C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_7_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_8_AF_LEDTS2_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_8_AF_LEDTS2_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_8_AF_LEDTS1_COL3 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_8_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_8_AF_U1C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_9_AF_LEDTS2_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_9_AF_LEDTS2_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_9_AF_LEDTS1_COL2 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_9_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_9_AF_U1C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_10_AF_LEDTS2_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_10_AF_LEDTS2_COL1	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_10_AF_LEDTS1_COL1	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_10_AF_U1C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_11_AF_LEDTS2_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_11_AF_LEDTS2_COL0	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_11_AF_LEDTS1_COL0	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_11_AF_U1C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P0_0_HWCTRL_LEDTS0_TSIN7      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_1_HWCTRL_LEDTS0_TSIN6      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_2_HWCTRL_LEDTS0_TSIN5      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_3_HWCTRL_LEDTS0_TSIN4      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_4_HWCTRL_LEDTS0_TSIN3      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_5_HWCTRL_LEDTS0_TSIN2      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_6_HWCTRL_LEDTS0_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_7_HWCTRL_LEDTS0_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_8_HWCTRL_LEDTS1_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_9_HWCTRL_LEDTS1_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_10_HWCTRL_LEDTS1_TSIN2     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_11_HWCTRL_LEDTS1_TSIN3     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_12_HWCTRL_LEDTS1_TSIN4     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_13_HWCTRL_LEDTS1_TSIN5     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_14_HWCTRL_LEDTS1_TSIN6     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_15_HWCTRL_LEDTS1_TSIN7     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_1_HWCTRL_U1C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_2_HWCTRL_U1C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_3_HWCTRL_U1C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_4_HWCTRL_U1C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P4_4_HWCTRL_LEDTS2_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_5_HWCTRL_LEDTS2_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_6_HWCTRL_LEDTS2_TSIN2      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_7_HWCTRL_LEDTS2_TSIN3      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_8_HWCTRL_LEDTS2_TSIN4      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_9_HWCTRL_LEDTS2_TSIN5      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_10_HWCTRL_LEDTS2_TSIN6     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_11_HWCTRL_LEDTS2_TSIN7     	XMC_GPIO_HWCTRL_PERIPHERAL1
#endif


#if (UC_DEVICE == XMC1401) && (UC_PACKAGE == VQFN48)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P1_6	XMC_GPIO_PORT1, 6
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11
#define P2_12	XMC_GPIO_PORT2, 12
#define P2_13	XMC_GPIO_PORT2, 13
#define P3_0	XMC_GPIO_PORT3, 0
#define P4_4	XMC_GPIO_PORT4, 4
#define P4_5	XMC_GPIO_PORT4, 5
#define P4_6	XMC_GPIO_PORT4, 6
#define P4_7	XMC_GPIO_PORT4, 7


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_LEDTS0_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_LEDTS0_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_LEDTS0_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_2_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_LEDTS0_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_4_AF_LEDTS0_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_4_AF_LEDTS0_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_5_AF_LEDTS0_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_5_AF_LEDTS0_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_LEDTS0_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_6_AF_LEDTS0_COL1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_7_AF_LEDTS0_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_7_AF_LEDTS0_COL0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_VADC_EMUX12 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_7_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_8_AF_LEDTS1_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_8_AF_LEDTS0_COLA 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_9_AF_LEDTS1_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_9_AF_LEDTS0_COL6 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_10_AF_LEDTS1_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_10_AF_LEDTS0_COL5	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_LEDTS1_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_11_AF_LEDTS0_COL4	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_LEDTS1_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_12_AF_LEDTS0_COL3	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_12_AF_LEDTS1_COL3	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_LEDTS1_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_13_AF_LEDTS0_COL2	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_13_AF_LEDTS1_COL2	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_LEDTS1_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_14_AF_LEDTS0_COL1	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_14_AF_LEDTS1_COL1	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_LEDTS1_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_15_AF_LEDTS0_COL0	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_15_AF_LEDTS1_COL0	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_LEDTS0_COL0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_0_AF_LEDTS1_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_LEDTS0_COL1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_1_AF_LEDTS1_COL0 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_LEDTS0_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_2_AF_LEDTS1_COL1 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_LEDTS0_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_3_AF_LEDTS1_COL2 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_LEDTS0_COL4 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_4_AF_LEDTS1_COL3 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_5_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_LEDTS0_COLA 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_6_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_6_AF_LEDTS0_COL5 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_6_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_6_AF_U0C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_6_AF_U0C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_LEDTS1_COL5 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_LEDTS1_COL6 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_LEDTS1_COL4	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_LEDTS1_COL3	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_12_AF_VADC_EMUX00	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_12_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_12_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_12_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_12_AF_LEDTS2_COL6	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_13_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_13_AF_U1C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_13_AF_VADC_EMUX01	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_13_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_13_AF_CCU41_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_0_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P3_0_AF_LEDTS2_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P3_0_AF_U1C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_0_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_4_AF_LEDTS2_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_4_AF_LEDTS1_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_4_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_5_AF_LEDTS2_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_5_AF_LEDTS1_COL6 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_5_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_5_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_6_AF_LEDTS2_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_6_AF_LEDTS1_COL5 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_6_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_7_AF_LEDTS1_COL4 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_7_AF_U1C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_7_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9

/* HW control options */
#define P0_0_HWCTRL_LEDTS0_TSIN7      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_1_HWCTRL_LEDTS0_TSIN6      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_2_HWCTRL_LEDTS0_TSIN5      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_3_HWCTRL_LEDTS0_TSIN4      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_4_HWCTRL_LEDTS0_TSIN3      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_5_HWCTRL_LEDTS0_TSIN2      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_6_HWCTRL_LEDTS0_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_7_HWCTRL_LEDTS0_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_8_HWCTRL_LEDTS1_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_9_HWCTRL_LEDTS1_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_10_HWCTRL_LEDTS1_TSIN2     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_11_HWCTRL_LEDTS1_TSIN3     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_12_HWCTRL_LEDTS1_TSIN4     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_13_HWCTRL_LEDTS1_TSIN5     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_14_HWCTRL_LEDTS1_TSIN6     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_15_HWCTRL_LEDTS1_TSIN7     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P4_4_HWCTRL_LEDTS2_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_5_HWCTRL_LEDTS2_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_6_HWCTRL_LEDTS2_TSIN2      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_7_HWCTRL_LEDTS2_TSIN3      	XMC_GPIO_HWCTRL_PERIPHERAL1
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == LQFP64)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P1_6	XMC_GPIO_PORT1, 6
#define P1_7	XMC_GPIO_PORT1, 7
#define P1_8	XMC_GPIO_PORT1, 8
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11
#define P2_12	XMC_GPIO_PORT2, 12
#define P2_13	XMC_GPIO_PORT2, 13
#define P3_0	XMC_GPIO_PORT3, 0
#define P3_1	XMC_GPIO_PORT3, 1
#define P3_2	XMC_GPIO_PORT3, 2
#define P3_3	XMC_GPIO_PORT3, 3
#define P3_4	XMC_GPIO_PORT3, 4
#define P4_0	XMC_GPIO_PORT4, 0
#define P4_1	XMC_GPIO_PORT4, 1
#define P4_2	XMC_GPIO_PORT4, 2
#define P4_3	XMC_GPIO_PORT4, 3
#define P4_4	XMC_GPIO_PORT4, 4
#define P4_5	XMC_GPIO_PORT4, 5
#define P4_6	XMC_GPIO_PORT4, 6
#define P4_7	XMC_GPIO_PORT4, 7
#define P4_8	XMC_GPIO_PORT4, 8
#define P4_9	XMC_GPIO_PORT4, 9
#define P4_10	XMC_GPIO_PORT4, 10
#define P4_11	XMC_GPIO_PORT4, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_0_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_1_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_CCU80_OUT02 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_2_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_CCU80_OUT03 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_3_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_CCU80_OUT13 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_CCU80_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_7_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_VADC_EMUX12 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_7_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_8_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_8_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_9_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_9_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_10_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_10_AF_CCU80_OUT22	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_CCU81_OUT22	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_11_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_CCU80_OUT23	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_CCU81_OUT23	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_12_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_12_AF_CCU80_OUT33	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_12_AF_CCU80_OUT20	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_CCU80_OUT32	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_CCU80_OUT21	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_14_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_BCCU0_OUT8 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_15_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_CCU81_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_4_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_5_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_5_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_6_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_6_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_6_AF_U0C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_6_AF_U0C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_6_AF_CCU81_OUT30 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_7_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_7_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_7_AF_ACMP3_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_7_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_7_AF_CCU81_OUT31 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_7_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_8_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_8_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_8_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_8_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_8_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_8_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_8_AF_CCU81_OUT32 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_12_AF_BCCU0_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_12_AF_VADC_EMUX00	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_12_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_12_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_12_AF_ACMP2_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_12_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_13_AF_BCCU0_OUT4 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_13_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_13_AF_U1C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_13_AF_CCU81_OUT31	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_13_AF_VADC_EMUX01	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_13_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_13_AF_CCU81_OUT33	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_13_AF_CCU41_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_0_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P3_0_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_0_AF_U1C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_0_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P3_0_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_1_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_1_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_1_AF_ACMP3_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_1_AF_U1C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_1_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P3_1_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_2_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_2_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_2_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_2_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P3_2_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_3_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_3_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_3_AF_ACMP0_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_3_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_3_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P3_3_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_4_AF_BCCU0_OUT6  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_4_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_4_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P3_4_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_4_AF_U1C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_4_AF_U1C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_4_AF_CCU81_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_0_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_0_AF_ERU1_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_0_AF_U1C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_0_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_0_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_1_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_1_AF_ERU1_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_1_AF_ACMP3_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_1_AF_U1C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_1_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_1_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_2_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_2_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_2_AF_ERU1_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_2_AF_U1C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_2_AF_CCU81_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_2_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_3_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_3_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_3_AF_ERU1_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_3_AF_ACMP0_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_3_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_3_AF_CCU81_OUT13 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_3_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_4_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_4_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_4_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_5_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_5_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_5_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_5_AF_CCU81_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_6_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_6_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_6_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_6_AF_CCU81_OUT02 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_7_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_7_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_7_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_7_AF_U1C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_7_AF_CCU81_OUT03 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_7_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_8_AF_BCCU0_OUT7  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_8_AF_CCU80_OUT30 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_8_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_8_AF_U1C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_8_AF_CCU81_OUT30 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_9_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_9_AF_CCU80_OUT31 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_9_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_9_AF_U1C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_9_AF_CCU81_OUT31 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_10_AF_CCU80_OUT00	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_10_AF_U1C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_10_AF_CCU81_OUT32	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_10_AF_CCU81_OUT00	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_11_AF_CCU80_OUT01	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_11_AF_U1C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_11_AF_CCU81_OUT33	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_11_AF_CCU81_OUT01	XMC_GPIO_MODE_OUTPUT_ALT9

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_1_HWCTRL_U1C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_2_HWCTRL_U1C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_3_HWCTRL_U1C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_4_HWCTRL_U1C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == VQFN40)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P1_6	XMC_GPIO_PORT1, 6
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_0_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_1_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_CCU80_OUT02 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_2_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_CCU80_OUT03 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_3_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_CCU80_OUT13 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_CCU80_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_7_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_VADC_EMUX12 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_7_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_8_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_8_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_9_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_9_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_10_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_10_AF_CCU80_OUT22	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_CCU81_OUT22	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_11_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_CCU80_OUT23	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_CCU81_OUT23	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_12_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_12_AF_CCU80_OUT33	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_12_AF_CCU80_OUT20	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_CCU80_OUT32	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_CCU80_OUT21	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_14_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_BCCU0_OUT8 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_15_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_CCU81_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_4_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_5_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_5_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_6_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_6_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_6_AF_U0C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_6_AF_U0C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_6_AF_CCU81_OUT30 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == VQFN48)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P1_6	XMC_GPIO_PORT1, 6
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11
#define P2_12	XMC_GPIO_PORT2, 12
#define P2_13	XMC_GPIO_PORT2, 13
#define P3_0	XMC_GPIO_PORT3, 0
#define P4_4	XMC_GPIO_PORT4, 4
#define P4_5	XMC_GPIO_PORT4, 5
#define P4_6	XMC_GPIO_PORT4, 6
#define P4_7	XMC_GPIO_PORT4, 7


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_0_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_1_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_CCU80_OUT02 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_2_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_CCU80_OUT03 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_3_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_CCU80_OUT13 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_CCU80_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_7_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_VADC_EMUX12 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_7_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_8_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_8_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_9_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_9_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_10_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_10_AF_CCU80_OUT22	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_CCU81_OUT22	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_11_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_CCU80_OUT23	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_CCU81_OUT23	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_12_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_12_AF_CCU80_OUT33	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_12_AF_CCU80_OUT20	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_CCU80_OUT32	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_CCU80_OUT21	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_14_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_BCCU0_OUT8 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_15_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_CCU81_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_4_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_5_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_5_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_6_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_6_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_6_AF_U0C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_6_AF_U0C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_6_AF_CCU81_OUT30 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_12_AF_BCCU0_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_12_AF_VADC_EMUX00	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_12_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_12_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_12_AF_ACMP2_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_12_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_13_AF_BCCU0_OUT4 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_13_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_13_AF_U1C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_13_AF_CCU81_OUT31	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_13_AF_VADC_EMUX01	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_13_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_13_AF_CCU81_OUT33	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_13_AF_CCU41_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_0_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P3_0_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_0_AF_U1C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_0_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P3_0_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_4_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_4_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_4_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_5_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_5_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_5_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_5_AF_CCU81_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_6_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_6_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_6_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_6_AF_CCU81_OUT02 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_7_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_7_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_7_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_7_AF_U1C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_7_AF_CCU81_OUT03 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_7_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == VQFN64)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P1_6	XMC_GPIO_PORT1, 6
#define P1_7	XMC_GPIO_PORT1, 7
#define P1_8	XMC_GPIO_PORT1, 8
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11
#define P2_12	XMC_GPIO_PORT2, 12
#define P2_13	XMC_GPIO_PORT2, 13
#define P3_0	XMC_GPIO_PORT3, 0
#define P3_1	XMC_GPIO_PORT3, 1
#define P3_2	XMC_GPIO_PORT3, 2
#define P3_3	XMC_GPIO_PORT3, 3
#define P3_4	XMC_GPIO_PORT3, 4
#define P4_0	XMC_GPIO_PORT4, 0
#define P4_1	XMC_GPIO_PORT4, 1
#define P4_2	XMC_GPIO_PORT4, 2
#define P4_3	XMC_GPIO_PORT4, 3
#define P4_4	XMC_GPIO_PORT4, 4
#define P4_5	XMC_GPIO_PORT4, 5
#define P4_6	XMC_GPIO_PORT4, 6
#define P4_7	XMC_GPIO_PORT4, 7
#define P4_8	XMC_GPIO_PORT4, 8
#define P4_9	XMC_GPIO_PORT4, 9
#define P4_10	XMC_GPIO_PORT4, 10
#define P4_11	XMC_GPIO_PORT4, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_0_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_1_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_CCU80_OUT02 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_2_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_CCU80_OUT03 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_3_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_CCU80_OUT13 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_CCU80_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_7_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_VADC_EMUX12 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_7_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_8_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_8_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_9_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_9_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_10_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_10_AF_CCU80_OUT22	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_CCU81_OUT22	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_11_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_CCU80_OUT23	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_CCU81_OUT23	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_12_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_12_AF_CCU80_OUT33	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_12_AF_CCU80_OUT20	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_CCU80_OUT32	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_CCU80_OUT21	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_14_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_BCCU0_OUT8 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_15_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_CCU81_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_4_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_5_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_5_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_6_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_6_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_6_AF_U0C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_6_AF_U0C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_6_AF_CCU81_OUT30 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_7_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_7_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_7_AF_ACMP3_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_7_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_7_AF_CCU81_OUT31 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_7_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_8_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_8_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_8_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_8_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_8_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_8_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_8_AF_CCU81_OUT32 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_12_AF_BCCU0_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_12_AF_VADC_EMUX00	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_12_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_12_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_12_AF_ACMP2_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_12_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_13_AF_BCCU0_OUT4 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_13_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_13_AF_U1C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_13_AF_CCU81_OUT31	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_13_AF_VADC_EMUX01	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_13_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_13_AF_CCU81_OUT33	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_13_AF_CCU41_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_0_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P3_0_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_0_AF_U1C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_0_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P3_0_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_1_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_1_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_1_AF_ACMP3_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_1_AF_U1C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_1_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P3_1_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_2_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_2_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_2_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_2_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P3_2_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_3_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_3_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_3_AF_ACMP0_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_3_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_3_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P3_3_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_4_AF_BCCU0_OUT6  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_4_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_4_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P3_4_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_4_AF_U1C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_4_AF_U1C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_4_AF_CCU81_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_0_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_0_AF_ERU1_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_0_AF_U1C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_0_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_0_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_1_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_1_AF_ERU1_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_1_AF_ACMP3_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_1_AF_U1C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_1_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_1_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_2_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_2_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_2_AF_ERU1_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_2_AF_U1C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_2_AF_CCU81_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_2_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_3_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_3_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_3_AF_ERU1_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_3_AF_ACMP0_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_3_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_3_AF_CCU81_OUT13 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_3_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_4_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_4_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_4_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_5_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_5_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_5_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_5_AF_CCU81_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_6_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_6_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_6_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_6_AF_CCU81_OUT02 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_7_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_7_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_7_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_7_AF_U1C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_7_AF_CCU81_OUT03 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_7_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_8_AF_BCCU0_OUT7  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_8_AF_CCU80_OUT30 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_8_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_8_AF_U1C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_8_AF_CCU81_OUT30 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_9_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_9_AF_CCU80_OUT31 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_9_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_9_AF_U1C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_9_AF_CCU81_OUT31 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_10_AF_CCU80_OUT00	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_10_AF_U1C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_10_AF_CCU81_OUT32	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_10_AF_CCU81_OUT00	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_11_AF_CCU80_OUT01	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_11_AF_U1C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_11_AF_CCU81_OUT33	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_11_AF_CCU81_OUT01	XMC_GPIO_MODE_OUTPUT_ALT9

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_1_HWCTRL_U1C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_2_HWCTRL_U1C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_3_HWCTRL_U1C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_4_HWCTRL_U1C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == TSSOP38)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_0_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_1_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_CCU80_OUT02 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_2_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_CCU80_OUT03 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_3_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_CCU80_OUT13 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_CCU80_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_7_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_VADC_EMUX12 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_7_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_8_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_8_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_9_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_9_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_10_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_10_AF_CCU80_OUT22	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_CCU81_OUT22	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_11_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_CCU80_OUT23	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_CCU81_OUT23	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_12_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_12_AF_CCU80_OUT33	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_12_AF_CCU80_OUT20	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_CCU80_OUT32	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_CCU80_OUT21	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_14_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_BCCU0_OUT8 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_15_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_CCU81_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_4_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_5_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_5_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1403) && (UC_PACKAGE == VQFN40)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P1_6	XMC_GPIO_PORT1, 6
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_2_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_4_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_5_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_VADC_EMUX12 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_7_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_12_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_CAN_N0_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_CAN_N0_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_CAN_N1_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_CAN_N1_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_4_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_5_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_6_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_6_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_6_AF_U0C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_6_AF_U0C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1403) && (UC_PACKAGE == VQFN48)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P1_6	XMC_GPIO_PORT1, 6
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11
#define P2_12	XMC_GPIO_PORT2, 12
#define P2_13	XMC_GPIO_PORT2, 13
#define P3_0	XMC_GPIO_PORT3, 0
#define P4_4	XMC_GPIO_PORT4, 4
#define P4_5	XMC_GPIO_PORT4, 5
#define P4_6	XMC_GPIO_PORT4, 6
#define P4_7	XMC_GPIO_PORT4, 7


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_2_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_4_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_5_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_VADC_EMUX12 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_7_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_12_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_CAN_N0_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_CAN_N0_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_CAN_N1_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_CAN_N1_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_4_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_5_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_6_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_6_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_6_AF_U0C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_6_AF_U0C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_12_AF_VADC_EMUX00	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_12_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_12_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_12_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_13_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_13_AF_U1C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_13_AF_VADC_EMUX01	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_13_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_13_AF_CCU41_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_0_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P3_0_AF_U1C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_0_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_4_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_5_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_5_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_6_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_7_AF_U1C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_7_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1403) && (UC_PACKAGE == VQFN64)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P1_6	XMC_GPIO_PORT1, 6
#define P1_7	XMC_GPIO_PORT1, 7
#define P1_8	XMC_GPIO_PORT1, 8
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11
#define P2_12	XMC_GPIO_PORT2, 12
#define P2_13	XMC_GPIO_PORT2, 13
#define P3_0	XMC_GPIO_PORT3, 0
#define P3_1	XMC_GPIO_PORT3, 1
#define P3_2	XMC_GPIO_PORT3, 2
#define P3_3	XMC_GPIO_PORT3, 3
#define P3_4	XMC_GPIO_PORT3, 4
#define P4_0	XMC_GPIO_PORT4, 0
#define P4_1	XMC_GPIO_PORT4, 1
#define P4_2	XMC_GPIO_PORT4, 2
#define P4_3	XMC_GPIO_PORT4, 3
#define P4_4	XMC_GPIO_PORT4, 4
#define P4_5	XMC_GPIO_PORT4, 5
#define P4_6	XMC_GPIO_PORT4, 6
#define P4_7	XMC_GPIO_PORT4, 7
#define P4_8	XMC_GPIO_PORT4, 8
#define P4_9	XMC_GPIO_PORT4, 9
#define P4_10	XMC_GPIO_PORT4, 10
#define P4_11	XMC_GPIO_PORT4, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_2_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_4_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_5_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_VADC_EMUX12 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_7_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_12_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_CAN_N0_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_CAN_N0_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_CAN_N1_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_CAN_N1_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_4_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_5_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_6_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_6_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_6_AF_U0C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_6_AF_U0C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_7_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_7_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_7_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_8_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_8_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_8_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_8_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_12_AF_VADC_EMUX00	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_12_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_12_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_12_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_13_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_13_AF_U1C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_13_AF_VADC_EMUX01	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_13_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_13_AF_CCU41_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_0_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P3_0_AF_U1C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_0_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_1_AF_U1C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_1_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_2_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_2_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_3_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_3_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_4_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_4_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P3_4_AF_U1C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_4_AF_U1C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_0_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_0_AF_ERU1_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_0_AF_U1C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_0_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_1_AF_ERU1_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_1_AF_U1C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_1_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_2_AF_ERU1_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_2_AF_U1C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_2_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_3_AF_ERU1_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_3_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_3_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_4_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_5_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_5_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_6_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_7_AF_U1C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_7_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_8_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_8_AF_U1C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_8_AF_CAN_N1_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_9_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_9_AF_U1C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_9_AF_CAN_N1_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_10_AF_U1C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_11_AF_U1C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT7

/* HW control options */
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_1_HWCTRL_U1C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_2_HWCTRL_U1C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_3_HWCTRL_U1C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_4_HWCTRL_U1C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#endif


#if (UC_DEVICE == XMC1404) && (UC_PACKAGE == LQFP64)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P1_6	XMC_GPIO_PORT1, 6
#define P1_7	XMC_GPIO_PORT1, 7
#define P1_8	XMC_GPIO_PORT1, 8
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11
#define P2_12	XMC_GPIO_PORT2, 12
#define P2_13	XMC_GPIO_PORT2, 13
#define P3_0	XMC_GPIO_PORT3, 0
#define P3_1	XMC_GPIO_PORT3, 1
#define P3_2	XMC_GPIO_PORT3, 2
#define P3_3	XMC_GPIO_PORT3, 3
#define P3_4	XMC_GPIO_PORT3, 4
#define P4_0	XMC_GPIO_PORT4, 0
#define P4_1	XMC_GPIO_PORT4, 1
#define P4_2	XMC_GPIO_PORT4, 2
#define P4_3	XMC_GPIO_PORT4, 3
#define P4_4	XMC_GPIO_PORT4, 4
#define P4_5	XMC_GPIO_PORT4, 5
#define P4_6	XMC_GPIO_PORT4, 6
#define P4_7	XMC_GPIO_PORT4, 7
#define P4_8	XMC_GPIO_PORT4, 8
#define P4_9	XMC_GPIO_PORT4, 9
#define P4_10	XMC_GPIO_PORT4, 10
#define P4_11	XMC_GPIO_PORT4, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_LEDTS0_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_0_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_LEDTS0_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_1_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_LEDTS0_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_CCU80_OUT02 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_2_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_LEDTS0_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_CCU80_OUT03 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_3_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_4_AF_LEDTS0_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_4_AF_LEDTS0_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_CCU80_OUT13 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_4_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_5_AF_LEDTS0_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_5_AF_LEDTS0_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_CCU80_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_5_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_6_AF_LEDTS0_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_6_AF_LEDTS0_COL1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_7_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_7_AF_LEDTS0_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_7_AF_LEDTS0_COL0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_VADC_EMUX12 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_7_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_8_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_8_AF_LEDTS1_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_8_AF_LEDTS0_COLA 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_8_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_9_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_9_AF_LEDTS1_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_9_AF_LEDTS0_COL6 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_9_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_10_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_10_AF_LEDTS1_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_10_AF_LEDTS0_COL5	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_10_AF_CCU80_OUT22	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_CCU81_OUT22	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_11_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_11_AF_LEDTS1_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_11_AF_LEDTS0_COL4	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_CCU80_OUT23	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_CCU81_OUT23	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_12_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_12_AF_LEDTS1_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_12_AF_LEDTS0_COL3	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_12_AF_LEDTS1_COL3	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_12_AF_CCU80_OUT33	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_12_AF_CCU80_OUT20	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_LEDTS1_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_13_AF_LEDTS0_COL2	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_13_AF_LEDTS1_COL2	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_13_AF_CCU80_OUT32	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_CCU80_OUT21	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_13_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_14_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_14_AF_LEDTS1_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_14_AF_LEDTS0_COL1	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_14_AF_LEDTS1_COL1	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_14_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_CAN_N0_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_15_AF_BCCU0_OUT8 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_15_AF_LEDTS1_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_15_AF_LEDTS0_COL0	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_15_AF_LEDTS1_COL0	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_15_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_CAN_N0_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_LEDTS0_COL0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_0_AF_LEDTS1_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_0_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_LEDTS0_COL1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_1_AF_LEDTS1_COL0 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_CCU81_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_1_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_LEDTS0_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_2_AF_LEDTS1_COL1 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_2_AF_CAN_N1_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_LEDTS0_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_3_AF_LEDTS1_COL2 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_3_AF_CAN_N1_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_4_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_LEDTS0_COL4 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_4_AF_LEDTS1_COL3 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_4_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_5_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_LEDTS0_COLA 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_5_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_6_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_6_AF_LEDTS0_COL5 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_6_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_6_AF_U0C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_6_AF_U0C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_6_AF_CCU81_OUT30 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_7_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_7_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_7_AF_LEDTS0_COL6 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_7_AF_LEDTS1_COL4 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_7_AF_ACMP3_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_7_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_7_AF_CCU81_OUT31 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_7_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_8_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_8_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_8_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_8_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_8_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_8_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_8_AF_CCU81_OUT32 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_LEDTS1_COL5 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_0_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_0_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_LEDTS1_COL6 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_1_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_1_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_LEDTS1_COL4	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_10_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_LEDTS1_COL3	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_11_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_12_AF_BCCU0_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_12_AF_VADC_EMUX00	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_12_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_12_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_12_AF_ACMP2_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_12_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_12_AF_LEDTS2_COL6	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_13_AF_BCCU0_OUT4 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_13_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_13_AF_U1C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_13_AF_CCU81_OUT31	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_13_AF_VADC_EMUX01	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_13_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_13_AF_CCU81_OUT33	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_13_AF_CCU41_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_0_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P3_0_AF_LEDTS2_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P3_0_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_0_AF_U1C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_0_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P3_0_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_1_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_1_AF_LEDTS2_COL0 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P3_1_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_1_AF_ACMP3_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_1_AF_U1C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_1_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P3_1_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_2_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_2_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_2_AF_LEDTS2_COL1 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P3_2_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_2_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P3_2_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_3_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_3_AF_LEDTS2_COL2 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P3_3_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_3_AF_ACMP0_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_3_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_3_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P3_3_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_4_AF_BCCU0_OUT6  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_4_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_4_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P3_4_AF_LEDTS2_COL3 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P3_4_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_4_AF_U1C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_4_AF_U1C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_4_AF_CCU81_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_0_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_0_AF_LEDTS2_COL5 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_0_AF_ERU1_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_0_AF_U1C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_0_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_0_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_1_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_1_AF_LEDTS2_COL4 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_1_AF_ERU1_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_1_AF_ACMP3_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_1_AF_U1C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_1_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_1_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_2_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_2_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_2_AF_ERU1_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_2_AF_U1C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_2_AF_CCU81_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_2_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_3_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_3_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_3_AF_ERU1_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_3_AF_ACMP0_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_3_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_3_AF_CCU81_OUT13 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_3_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_4_AF_LEDTS2_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_4_AF_LEDTS1_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_4_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_4_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_4_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_5_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_5_AF_LEDTS2_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_5_AF_LEDTS1_COL6 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_5_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_5_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_5_AF_CCU81_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_6_AF_LEDTS2_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_6_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_6_AF_LEDTS1_COL5 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_6_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_6_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_6_AF_CCU81_OUT02 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_7_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_7_AF_LEDTS2_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_7_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_7_AF_LEDTS1_COL4 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_7_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_7_AF_U1C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_7_AF_CCU81_OUT03 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_7_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_8_AF_BCCU0_OUT7  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_8_AF_LEDTS2_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_8_AF_LEDTS2_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_8_AF_LEDTS1_COL3 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_8_AF_CCU80_OUT30 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_8_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_8_AF_U1C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_8_AF_CCU81_OUT30 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_8_AF_CAN_N1_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_9_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_9_AF_LEDTS2_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_9_AF_LEDTS2_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_9_AF_LEDTS1_COL2 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_9_AF_CCU80_OUT31 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_9_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_9_AF_U1C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_9_AF_CCU81_OUT31 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_9_AF_CAN_N1_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_10_AF_LEDTS2_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_10_AF_LEDTS2_COL1	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_10_AF_LEDTS1_COL1	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_10_AF_CCU80_OUT00	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_10_AF_U1C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_10_AF_CCU81_OUT32	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_10_AF_CCU81_OUT00	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_11_AF_LEDTS2_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_11_AF_LEDTS2_COL0	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_11_AF_LEDTS1_COL0	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_11_AF_CCU80_OUT01	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_11_AF_U1C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_11_AF_CCU81_OUT33	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_11_AF_CCU81_OUT01	XMC_GPIO_MODE_OUTPUT_ALT9

/* HW control options */
#define P0_0_HWCTRL_LEDTS0_TSIN7      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_1_HWCTRL_LEDTS0_TSIN6      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_2_HWCTRL_LEDTS0_TSIN5      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_3_HWCTRL_LEDTS0_TSIN4      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_4_HWCTRL_LEDTS0_TSIN3      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_5_HWCTRL_LEDTS0_TSIN2      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_6_HWCTRL_LEDTS0_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_7_HWCTRL_LEDTS0_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_8_HWCTRL_LEDTS1_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_9_HWCTRL_LEDTS1_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_10_HWCTRL_LEDTS1_TSIN2     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_11_HWCTRL_LEDTS1_TSIN3     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_12_HWCTRL_LEDTS1_TSIN4     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_13_HWCTRL_LEDTS1_TSIN5     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_14_HWCTRL_LEDTS1_TSIN6     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_15_HWCTRL_LEDTS1_TSIN7     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_1_HWCTRL_U1C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_2_HWCTRL_U1C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_3_HWCTRL_U1C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_4_HWCTRL_U1C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P4_4_HWCTRL_LEDTS2_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_5_HWCTRL_LEDTS2_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_6_HWCTRL_LEDTS2_TSIN2      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_7_HWCTRL_LEDTS2_TSIN3      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_8_HWCTRL_LEDTS2_TSIN4      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_9_HWCTRL_LEDTS2_TSIN5      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_10_HWCTRL_LEDTS2_TSIN6     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_11_HWCTRL_LEDTS2_TSIN7     	XMC_GPIO_HWCTRL_PERIPHERAL1
#endif


#if (UC_DEVICE == XMC1404) && (UC_PACKAGE == VQFN48)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P1_6	XMC_GPIO_PORT1, 6
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11
#define P2_12	XMC_GPIO_PORT2, 12
#define P2_13	XMC_GPIO_PORT2, 13
#define P3_0	XMC_GPIO_PORT3, 0
#define P4_4	XMC_GPIO_PORT4, 4
#define P4_5	XMC_GPIO_PORT4, 5
#define P4_6	XMC_GPIO_PORT4, 6
#define P4_7	XMC_GPIO_PORT4, 7


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_LEDTS0_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_0_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_LEDTS0_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_1_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_LEDTS0_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_CCU80_OUT02 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_2_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_LEDTS0_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_CCU80_OUT03 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_3_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_4_AF_LEDTS0_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_4_AF_LEDTS0_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_CCU80_OUT13 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_4_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_5_AF_LEDTS0_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_5_AF_LEDTS0_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_CCU80_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_5_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_6_AF_LEDTS0_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_6_AF_LEDTS0_COL1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_7_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_7_AF_LEDTS0_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_7_AF_LEDTS0_COL0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_VADC_EMUX12 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_7_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_8_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_8_AF_LEDTS1_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_8_AF_LEDTS0_COLA 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_8_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_9_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_9_AF_LEDTS1_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_9_AF_LEDTS0_COL6 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_9_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_10_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_10_AF_LEDTS1_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_10_AF_LEDTS0_COL5	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_10_AF_CCU80_OUT22	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_CCU81_OUT22	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_11_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_11_AF_LEDTS1_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_11_AF_LEDTS0_COL4	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_CCU80_OUT23	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_CCU81_OUT23	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_12_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_12_AF_LEDTS1_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_12_AF_LEDTS0_COL3	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_12_AF_LEDTS1_COL3	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_12_AF_CCU80_OUT33	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_12_AF_CCU80_OUT20	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_LEDTS1_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_13_AF_LEDTS0_COL2	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_13_AF_LEDTS1_COL2	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_13_AF_CCU80_OUT32	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_CCU80_OUT21	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_13_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_14_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_14_AF_LEDTS1_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_14_AF_LEDTS0_COL1	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_14_AF_LEDTS1_COL1	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_14_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_CAN_N0_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_15_AF_BCCU0_OUT8 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_15_AF_LEDTS1_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_15_AF_LEDTS0_COL0	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_15_AF_LEDTS1_COL0	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_15_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_CAN_N0_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_LEDTS0_COL0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_0_AF_LEDTS1_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_0_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_LEDTS0_COL1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_1_AF_LEDTS1_COL0 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_CCU81_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_1_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_LEDTS0_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_2_AF_LEDTS1_COL1 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_2_AF_CAN_N1_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_LEDTS0_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_3_AF_LEDTS1_COL2 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_3_AF_CAN_N1_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_4_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_LEDTS0_COL4 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_4_AF_LEDTS1_COL3 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_4_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_5_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_LEDTS0_COLA 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_5_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_6_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_6_AF_LEDTS0_COL5 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_6_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_6_AF_U0C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_6_AF_U0C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_6_AF_CCU81_OUT30 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_LEDTS1_COL5 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_0_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_0_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_LEDTS1_COL6 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_1_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_1_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_LEDTS1_COL4	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_10_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_LEDTS1_COL3	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_11_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_12_AF_BCCU0_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_12_AF_VADC_EMUX00	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_12_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_12_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_12_AF_ACMP2_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_12_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_12_AF_LEDTS2_COL6	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_13_AF_BCCU0_OUT4 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_13_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_13_AF_U1C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_13_AF_CCU81_OUT31	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_13_AF_VADC_EMUX01	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_13_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_13_AF_CCU81_OUT33	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_13_AF_CCU41_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_0_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P3_0_AF_LEDTS2_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P3_0_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_0_AF_U1C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_0_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P3_0_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_4_AF_LEDTS2_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_4_AF_LEDTS1_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_4_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_4_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_4_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_5_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_5_AF_LEDTS2_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_5_AF_LEDTS1_COL6 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_5_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_5_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_5_AF_CCU81_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_6_AF_LEDTS2_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_6_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_6_AF_LEDTS1_COL5 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_6_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_6_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_6_AF_CCU81_OUT02 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_7_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_7_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_7_AF_LEDTS1_COL4 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_7_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_7_AF_U1C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_7_AF_CCU81_OUT03 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_7_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9

/* HW control options */
#define P0_0_HWCTRL_LEDTS0_TSIN7      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_1_HWCTRL_LEDTS0_TSIN6      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_2_HWCTRL_LEDTS0_TSIN5      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_3_HWCTRL_LEDTS0_TSIN4      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_4_HWCTRL_LEDTS0_TSIN3      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_5_HWCTRL_LEDTS0_TSIN2      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_6_HWCTRL_LEDTS0_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_7_HWCTRL_LEDTS0_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_8_HWCTRL_LEDTS1_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_9_HWCTRL_LEDTS1_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_10_HWCTRL_LEDTS1_TSIN2     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_11_HWCTRL_LEDTS1_TSIN3     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_12_HWCTRL_LEDTS1_TSIN4     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_13_HWCTRL_LEDTS1_TSIN5     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_14_HWCTRL_LEDTS1_TSIN6     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_15_HWCTRL_LEDTS1_TSIN7     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P4_4_HWCTRL_LEDTS2_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_5_HWCTRL_LEDTS2_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_6_HWCTRL_LEDTS2_TSIN2      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_7_HWCTRL_LEDTS2_TSIN3      	XMC_GPIO_HWCTRL_PERIPHERAL1
#endif


#if (UC_DEVICE == XMC1404) && (UC_PACKAGE == VQFN64)
#define P0_0	XMC_GPIO_PORT0, 0
#define P0_1	XMC_GPIO_PORT0, 1
#define P0_2	XMC_GPIO_PORT0, 2
#define P0_3	XMC_GPIO_PORT0, 3
#define P0_4	XMC_GPIO_PORT0, 4
#define P0_5	XMC_GPIO_PORT0, 5
#define P0_6	XMC_GPIO_PORT0, 6
#define P0_7	XMC_GPIO_PORT0, 7
#define P0_8	XMC_GPIO_PORT0, 8
#define P0_9	XMC_GPIO_PORT0, 9
#define P0_10	XMC_GPIO_PORT0, 10
#define P0_11	XMC_GPIO_PORT0, 11
#define P0_12	XMC_GPIO_PORT0, 12
#define P0_13	XMC_GPIO_PORT0, 13
#define P0_14	XMC_GPIO_PORT0, 14
#define P0_15	XMC_GPIO_PORT0, 15
#define P1_0	XMC_GPIO_PORT1, 0
#define P1_1	XMC_GPIO_PORT1, 1
#define P1_2	XMC_GPIO_PORT1, 2
#define P1_3	XMC_GPIO_PORT1, 3
#define P1_4	XMC_GPIO_PORT1, 4
#define P1_5	XMC_GPIO_PORT1, 5
#define P1_6	XMC_GPIO_PORT1, 6
#define P1_7	XMC_GPIO_PORT1, 7
#define P1_8	XMC_GPIO_PORT1, 8
#define P2_0	XMC_GPIO_PORT2, 0
#define P2_1	XMC_GPIO_PORT2, 1
#define P2_2	XMC_GPIO_PORT2, 2
#define P2_3	XMC_GPIO_PORT2, 3
#define P2_4	XMC_GPIO_PORT2, 4
#define P2_5	XMC_GPIO_PORT2, 5
#define P2_6	XMC_GPIO_PORT2, 6
#define P2_7	XMC_GPIO_PORT2, 7
#define P2_8	XMC_GPIO_PORT2, 8
#define P2_9	XMC_GPIO_PORT2, 9
#define P2_10	XMC_GPIO_PORT2, 10
#define P2_11	XMC_GPIO_PORT2, 11
#define P2_12	XMC_GPIO_PORT2, 12
#define P2_13	XMC_GPIO_PORT2, 13
#define P3_0	XMC_GPIO_PORT3, 0
#define P3_1	XMC_GPIO_PORT3, 1
#define P3_2	XMC_GPIO_PORT3, 2
#define P3_3	XMC_GPIO_PORT3, 3
#define P3_4	XMC_GPIO_PORT3, 4
#define P4_0	XMC_GPIO_PORT4, 0
#define P4_1	XMC_GPIO_PORT4, 1
#define P4_2	XMC_GPIO_PORT4, 2
#define P4_3	XMC_GPIO_PORT4, 3
#define P4_4	XMC_GPIO_PORT4, 4
#define P4_5	XMC_GPIO_PORT4, 5
#define P4_6	XMC_GPIO_PORT4, 6
#define P4_7	XMC_GPIO_PORT4, 7
#define P4_8	XMC_GPIO_PORT4, 8
#define P4_9	XMC_GPIO_PORT4, 9
#define P4_10	XMC_GPIO_PORT4, 10
#define P4_11	XMC_GPIO_PORT4, 11


/* Alternate Output Function */
#define P0_0_AF_ERU0_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_0_AF_LEDTS0_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_0_AF_ERU0_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_0_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_0_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_0_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_1_AF_ERU0_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_1_AF_LEDTS0_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_1_AF_ERU0_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_1_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_1_AF_SCU_VDROP   	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_1_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_2_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_2_AF_LEDTS0_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_2_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_2_AF_CCU80_OUT02 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_2_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_2_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_3_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_3_AF_LEDTS0_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_3_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_3_AF_CCU80_OUT03 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_3_AF_VADC_EMUX01 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_3_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_4_AF_LEDTS0_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_4_AF_LEDTS0_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_4_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_4_AF_CCU80_OUT13 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_4_AF_VADC_EMUX00 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_4_AF_WDT_REQUEST 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_4_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_4_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_5_AF_LEDTS0_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_5_AF_LEDTS0_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_5_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_5_AF_CCU80_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_5_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_5_AF_VADC_EMUX10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_5_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_6_AF_LEDTS0_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_6_AF_LEDTS0_COL1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_6_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_6_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_6_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_6_AF_VADC_EMUX11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_6_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_7_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_7_AF_LEDTS0_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_7_AF_LEDTS0_COL0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_7_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_7_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_7_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_7_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_7_AF_VADC_EMUX12 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_7_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_8_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_8_AF_LEDTS1_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_8_AF_LEDTS0_COLA 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_8_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_8_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_8_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_8_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_8_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_8_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_9_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_9_AF_LEDTS1_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_9_AF_LEDTS0_COL6 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_9_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_9_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_9_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_9_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_9_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_9_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_10_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_10_AF_LEDTS1_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_10_AF_LEDTS0_COL5	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_10_AF_CCU80_OUT22	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_10_AF_U0C0_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_10_AF_U0C1_SELO1 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_10_AF_CCU81_OUT22	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_11_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_11_AF_LEDTS1_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_11_AF_LEDTS0_COL4	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_11_AF_U0C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_11_AF_CCU80_OUT23	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_11_AF_U0C0_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_11_AF_U0C1_SELO2 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_11_AF_CCU81_OUT23	XMC_GPIO_MODE_OUTPUT_ALT8
#define P0_12_AF_BCCU0_OUT6 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_12_AF_LEDTS1_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_12_AF_LEDTS0_COL3	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_12_AF_LEDTS1_COL3	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_12_AF_CCU80_OUT33	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_12_AF_U0C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_12_AF_CCU80_OUT20	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_12_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_13_AF_WDT_REQUEST	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_13_AF_LEDTS1_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_13_AF_LEDTS0_COL2	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_13_AF_LEDTS1_COL2	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_13_AF_CCU80_OUT32	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_13_AF_U0C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_13_AF_CCU80_OUT21	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_13_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_14_AF_BCCU0_OUT7 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_14_AF_LEDTS1_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_14_AF_LEDTS0_COL1	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_14_AF_LEDTS1_COL1	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_14_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_14_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_14_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_14_AF_CAN_N0_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P0_15_AF_BCCU0_OUT8 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P0_15_AF_LEDTS1_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P0_15_AF_LEDTS0_COL0	XMC_GPIO_MODE_OUTPUT_ALT3
#define P0_15_AF_LEDTS1_COL0	XMC_GPIO_MODE_OUTPUT_ALT4
#define P0_15_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P0_15_AF_U0C0_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P0_15_AF_U0C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P0_15_AF_CAN_N0_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_0_AF_LEDTS0_COL0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_0_AF_LEDTS1_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_0_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_0_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_0_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_1_AF_LEDTS0_COL1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_1_AF_LEDTS1_COL0 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_1_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_1_AF_U0C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_1_AF_CCU81_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_1_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_2_AF_LEDTS0_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_2_AF_LEDTS1_COL1 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_2_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_2_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_2_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_2_AF_CAN_N1_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_3_AF_LEDTS0_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_3_AF_LEDTS1_COL2 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_3_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_3_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_3_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_3_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_3_AF_CAN_N1_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_4_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_4_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_4_AF_LEDTS0_COL4 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_4_AF_LEDTS1_COL3 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_4_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_4_AF_U0C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_4_AF_U0C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_4_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_5_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_5_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_5_AF_LEDTS0_COLA 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_5_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_5_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_5_AF_U0C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_5_AF_U0C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_5_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_6_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_6_AF_U0C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_6_AF_LEDTS0_COL5 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_6_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P1_6_AF_U0C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_6_AF_U0C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_6_AF_CCU81_OUT30 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_7_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_7_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_7_AF_LEDTS0_COL6 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_7_AF_LEDTS1_COL4 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_7_AF_ACMP3_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_7_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_7_AF_CCU81_OUT31 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P1_7_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P1_8_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P1_8_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P1_8_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P1_8_AF_VADC_EMUX02 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P1_8_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P1_8_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P1_8_AF_CCU81_OUT32 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_0_AF_ERU0_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_0_AF_ERU0_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_0_AF_LEDTS1_COL5 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_0_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_0_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_0_AF_U0C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_0_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_0_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_1_AF_ERU0_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_1_AF_ERU0_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_1_AF_LEDTS1_COL6 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_1_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_1_AF_U0C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_1_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_1_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_1_AF_CAN_N0_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_10_AF_ERU0_PDOUT1	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_10_AF_ERU0_GOUT1 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_10_AF_LEDTS1_COL4	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_10_AF_CCU80_OUT30	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_10_AF_ACMP0_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_10_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_10_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_11_AF_ERU0_PDOUT0	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_11_AF_ERU0_GOUT0 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_11_AF_LEDTS1_COL3	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_11_AF_CCU80_OUT31	XMC_GPIO_MODE_OUTPUT_ALT5
#define P2_11_AF_U0C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_11_AF_U0C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_11_AF_CAN_N1_TXD 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P2_12_AF_BCCU0_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_12_AF_VADC_EMUX00	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_12_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_12_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_12_AF_ACMP2_OUT  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_12_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_12_AF_LEDTS2_COL6	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_13_AF_BCCU0_OUT4 	XMC_GPIO_MODE_OUTPUT_ALT1
#define P2_13_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P2_13_AF_U1C0_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P2_13_AF_CCU81_OUT31	XMC_GPIO_MODE_OUTPUT_ALT4
#define P2_13_AF_VADC_EMUX01	XMC_GPIO_MODE_OUTPUT_ALT6
#define P2_13_AF_U1C1_DOUT0 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P2_13_AF_CCU81_OUT33	XMC_GPIO_MODE_OUTPUT_ALT8
#define P2_13_AF_CCU41_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_0_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_0_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P3_0_AF_LEDTS2_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P3_0_AF_CCU80_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_0_AF_U1C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_0_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P3_0_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_1_AF_BCCU0_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_1_AF_U1C1_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_1_AF_LEDTS2_COL0 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P3_1_AF_CCU80_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_1_AF_ACMP3_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_1_AF_U1C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_1_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P3_1_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_2_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_2_AF_U1C1_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_2_AF_LEDTS2_COL1 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P3_2_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_2_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_2_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P3_2_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_3_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_3_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_3_AF_LEDTS2_COL2 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P3_3_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_3_AF_ACMP0_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_3_AF_U1C1_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_3_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P3_3_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P3_4_AF_BCCU0_OUT6  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P3_4_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT2
#define P3_4_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT3
#define P3_4_AF_LEDTS2_COL3 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P3_4_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P3_4_AF_U1C1_MCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT6
#define P3_4_AF_U1C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P3_4_AF_CCU81_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_0_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_0_AF_ERU1_PDOUT0 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_0_AF_LEDTS2_COL5 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_0_AF_ERU1_GOUT0  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_0_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_0_AF_ACMP1_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_0_AF_U1C1_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_0_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_0_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_1_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_1_AF_ERU1_PDOUT1 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_1_AF_LEDTS2_COL4 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_1_AF_ERU1_GOUT1  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_1_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_1_AF_ACMP3_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_1_AF_U1C1_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_1_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_1_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_2_AF_BCCU0_OUT4  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_2_AF_ERU1_PDOUT2 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_2_AF_CCU81_OUT20 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_2_AF_ERU1_GOUT2  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_2_AF_CCU40_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_2_AF_ACMP2_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_2_AF_U1C1_SELO3  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_2_AF_CCU81_OUT12 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_2_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_3_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_3_AF_ERU1_PDOUT3 	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_3_AF_CCU81_OUT21 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_3_AF_ERU1_GOUT3  	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_3_AF_CCU40_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_3_AF_ACMP0_OUT   	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_3_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_3_AF_CCU81_OUT13 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_3_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_4_AF_BCCU0_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_4_AF_LEDTS2_LINE0	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_4_AF_LEDTS1_COLA 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_4_AF_CCU80_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_4_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_4_AF_CCU81_OUT00 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_4_AF_CCU41_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_5_AF_BCCU0_OUT8  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_5_AF_LEDTS2_LINE1	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_5_AF_LEDTS1_COL6 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_5_AF_CCU80_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_5_AF_U1C0_DOUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_5_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_5_AF_CCU81_OUT01 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_5_AF_CCU41_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_6_AF_BCCU0_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_6_AF_LEDTS2_LINE2	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_6_AF_CCU81_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_6_AF_LEDTS1_COL5 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_6_AF_CCU80_OUT10 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_6_AF_U1C0_SCLKOUT	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_6_AF_CCU81_OUT02 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_6_AF_CCU41_OUT2  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_7_AF_BCCU0_OUT5  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_7_AF_LEDTS2_LINE3	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_7_AF_CCU81_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_7_AF_LEDTS1_COL4 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_7_AF_CCU80_OUT11 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_7_AF_U1C0_SELO0  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_7_AF_CCU81_OUT03 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_7_AF_CCU41_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_8_AF_BCCU0_OUT7  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_8_AF_LEDTS2_LINE4	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_8_AF_LEDTS2_COL3 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_8_AF_LEDTS1_COL3 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_8_AF_CCU80_OUT30 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_8_AF_CCU40_OUT0  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_8_AF_U1C0_SELO1  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_8_AF_CCU81_OUT30 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_8_AF_CAN_N1_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_9_AF_BCCU0_OUT3  	XMC_GPIO_MODE_OUTPUT_ALT1
#define P4_9_AF_LEDTS2_LINE5	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_9_AF_LEDTS2_COL2 	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_9_AF_LEDTS1_COL2 	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_9_AF_CCU80_OUT31 	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_9_AF_CCU40_OUT1  	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_9_AF_U1C0_SELO2  	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_9_AF_CCU81_OUT31 	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_9_AF_CAN_N1_TXD  	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_10_AF_LEDTS2_LINE6	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_10_AF_LEDTS2_COL1	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_10_AF_LEDTS1_COL1	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_10_AF_CCU80_OUT00	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_10_AF_CCU40_OUT2 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_10_AF_U1C0_SELO3 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_10_AF_CCU81_OUT32	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_10_AF_CCU81_OUT00	XMC_GPIO_MODE_OUTPUT_ALT9
#define P4_11_AF_LEDTS2_LINE7	XMC_GPIO_MODE_OUTPUT_ALT2
#define P4_11_AF_LEDTS2_COL0	XMC_GPIO_MODE_OUTPUT_ALT3
#define P4_11_AF_LEDTS1_COL0	XMC_GPIO_MODE_OUTPUT_ALT4
#define P4_11_AF_CCU80_OUT01	XMC_GPIO_MODE_OUTPUT_ALT5
#define P4_11_AF_CCU40_OUT3 	XMC_GPIO_MODE_OUTPUT_ALT6
#define P4_11_AF_U1C0_SELO4 	XMC_GPIO_MODE_OUTPUT_ALT7
#define P4_11_AF_CCU81_OUT33	XMC_GPIO_MODE_OUTPUT_ALT8
#define P4_11_AF_CCU81_OUT01	XMC_GPIO_MODE_OUTPUT_ALT9

/* HW control options */
#define P0_0_HWCTRL_LEDTS0_TSIN7      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_1_HWCTRL_LEDTS0_TSIN6      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_2_HWCTRL_LEDTS0_TSIN5      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_3_HWCTRL_LEDTS0_TSIN4      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_4_HWCTRL_LEDTS0_TSIN3      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_5_HWCTRL_LEDTS0_TSIN2      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_6_HWCTRL_LEDTS0_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_7_HWCTRL_LEDTS0_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_8_HWCTRL_LEDTS1_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_9_HWCTRL_LEDTS1_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_10_HWCTRL_LEDTS1_TSIN2     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_11_HWCTRL_LEDTS1_TSIN3     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_12_HWCTRL_LEDTS1_TSIN4     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_13_HWCTRL_LEDTS1_TSIN5     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_14_HWCTRL_LEDTS1_TSIN6     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P0_15_HWCTRL_LEDTS1_TSIN7     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P1_0_HWCTRL_U0C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_1_HWCTRL_U0C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_2_HWCTRL_U0C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P1_3_HWCTRL_U0C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_1_HWCTRL_U1C0_DOUT3        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_2_HWCTRL_U1C0_DOUT2        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_3_HWCTRL_U1C0_DOUT1        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P3_4_HWCTRL_U1C0_DOUT0        	XMC_GPIO_HWCTRL_PERIPHERAL2
#define P4_4_HWCTRL_LEDTS2_TSIN0      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_5_HWCTRL_LEDTS2_TSIN1      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_6_HWCTRL_LEDTS2_TSIN2      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_7_HWCTRL_LEDTS2_TSIN3      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_8_HWCTRL_LEDTS2_TSIN4      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_9_HWCTRL_LEDTS2_TSIN5      	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_10_HWCTRL_LEDTS2_TSIN6     	XMC_GPIO_HWCTRL_PERIPHERAL1
#define P4_11_HWCTRL_LEDTS2_TSIN7     	XMC_GPIO_HWCTRL_PERIPHERAL1
#endif

#endif /* XMC1_GPIO_MAP_H */
